﻿/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using DataAccess;
public partial class TBICDSXPat : System.Web.UI.Page
{
    /// <summary>
    /// US:5716 check that user is logged in, sanitize querystring values and automatically lookup the patient
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Page_Load(object sender, EventArgs e)
    {
        Session["PING_MDWS"] = "1";

        //only 5 params allowed on the query string (see above)
        //CPRS tools menu:
        //Name=Command: TBI CDS Application="
        //https://65.36.42.218/TBIPractitionerPortal/TBICDSXPAT.aspx?
        //p1=%DUZ&p2=%DFN&p3=%SRV&p4=%PORT&p5=%MREF"

        //TBICDSXPAT.aspx 
        //?p1=20001                                             %DUZ
        //&p2=100099                                            %DFN
        //&p3=54.227.240.209                                    %SRV
        //&p4=9210                                              %PORT
        //&p5=^TMP('ORWCHART',2480,'10.69.142.161',000503A6)    %MREF
        string strDUZ = String.Empty;
        string strDFN = String.Empty;
        string strSRV = String.Empty;
        string strPort = String.Empty;
        if (Request.QueryString.Count == 5)
        {
            //get the dfn etc... from the query string
            //sanitize the values to prevent XSS from query string
            strDUZ = CDataUtils2.Sanitize(Request.QueryString[0].ToString());
            strDFN = CDataUtils2.Sanitize(Request.QueryString[1].ToString());
            strSRV = CDataUtils2.Sanitize(Request.QueryString[2].ToString());
            strPort = CDataUtils2.Sanitize(Request.QueryString[3].ToString());

            if (String.IsNullOrEmpty(strDUZ))
            {
                Master.LogOff();
                return;
            }

            if (String.IsNullOrEmpty(strDFN))
            {
                Master.LogOff();
                return;
            }

            if (String.IsNullOrEmpty(strSRV))
            {
                Master.LogOff();
                return;
            }

            if (String.IsNullOrEmpty(strPort))
            {
                Master.LogOff();
                return;
            }

            //note: not using MREF right now            
        }
        else
        {
            //exactly 5 params are required on query string 
            Master.LogOff();
        }
        
        //we are logged in, check params and lookup patient
        if (Master.IsLoggedIn())
        {                
            //check that duz etc coming in is the same as the user logged in
            //will prevent users from randomly looking up patients without knowing 
            //both the duz and the dfn. 
            if (Master.DUZ != strDUZ)
            {
                Session["PING_MDWS"] = null;
        
                Master.LogOff();
                return;
            }
            if (Master.SRV != strSRV)
            {
                Session["PING_MDWS"] = null;
        
                Master.LogOff();
                return;
            }
            if (Master.PORT != strPort)
            {
                Session["PING_MDWS"] = null;
        
                Master.LogOff();
                return;
            }

            //transfer the patient from MDWS to the central db
            string strPatID = string.Empty;
            CMDWSOps opsPat = new CMDWSOps(Master.GetDataObject());
            CStatus stat = opsPat.TransferPatientByDFN(Master.Key,
                                                       strDFN,
                                                       out strPatID);
            //reset the patient id
            Master.SelectedPatientID = "";

            Session["PING_MDWS"] = null;
        
            //lookup the patient from the central db
            if (stat.Status)
            {
                Master.LookupPatient(false, strPatID);
            }
            else
            {
                //transfer failed so redirect home
                Master.GotoHomePage();
            }
        }
        else
        {
            //if we are not logged in set the duz, dfn etc...
            Master.DUZ = strDUZ;
            Master.DFN = strDFN;
            Master.SRV = strSRV;
            Master.PORT = strPort;

            Session["PING_MDWS"] = null;
        
           
            //login via cprs
            Master.LoginViaCPRS();
        }

        Session["PING_MDWS"] = null;
        
    }
}